<?php

if (!class_exists('wpmlFormHelper')) {
    class wpmlFormHelper extends wpMailPlugin
    {
        public $name = 'Form';

        public function __construct()
        {
            return true;
        }

        public function file($name = null, $options = array())
        {
            global $Html;

            $defaults = array(
                'error' 		=> 	true,
                'class'			=>	"widefat",
                'width'			=>	"auto",
            );

            $r = wp_parse_args($options, $defaults);
            extract($r, EXTR_SKIP);

            ob_start(); ?><input class="<?php echo $class; ?>" style="width:<?php echo $width; ?>;" type="file" name="<?php echo $name; ?>" id="<?php echo $Html -> field_id($name); ?>" /><?php

            if ($error == true) {
                echo $Html -> field_error($name);
            }

            $file = ob_get_clean();
            return $file;
        }

        public function hidden($name = null, $options = array())
        {
            global $Html;

            $defaults = array();
            $r = wp_parse_args($options, $defaults);
            extract($r, EXTR_SKIP);

            ob_start(); ?><input type="hidden" name="<?php echo $name; ?>" value="<?php echo esc_attr(wp_unslash($Html -> field_value($name))); ?>" /><?php

            $hidden = ob_get_clean();
            return $hidden;
        }

        public function text($name = null, $options = array())
        {
            global $Html;

            $defaults = array(
                'width' 		=> 	"100%",
                'class'			=>	"widefat",
                'error' 		=> 	true,
                'id' 			=> 	$Html -> field_id($name),
                'autocomplete'	=>	"on",
                'tabindex'		=>	false,
                'placeholder'	=>	false,
            );

            $r = wp_parse_args($options, $defaults);
            extract($r, EXTR_SKIP);

            if ($Html -> has_field_error($name)) {
                $class .= ' newsletters_fielderror';
            }

            ob_start(); ?><input placeholder="<?php echo esc_attr(wp_unslash($placeholder)); ?>" autocomplete="<?php echo $autocomplete; ?>" <?php echo (empty($tabindex)) ? '' : 'tabindex="' . esc_attr(wp_unslash($tabindex)) . '"'; ?> class="<?php echo $class; ?>" style="width:<?php echo $width; ?>;" id="<?php echo $id; ?>" type="text" name="<?php echo $name; ?>" value="<?php echo esc_attr(wp_unslash($Html -> field_value($name))); ?>" /><?php

            if ($error != false) {
                echo $Html -> field_error($name);
            }

            $text = ob_get_clean();
            return $text;
        }

        public function textarea($name = null, $options = array())
        {
            global $Html;

            $defaults = array('error' => true, 'width' => "100%", 'cols' => "100%", 'class' => "widefat", 'rows' => 5);
            $r = wp_parse_args($options, $defaults);
            extract($r, EXTR_SKIP);

            ob_start(); ?><textarea style="width:<?php echo $width; ?>;" class="<?php echo $class; ?>" name="<?php echo $name; ?>" id="<?php echo $Html -> field_id($name); ?>" cols="<?php echo $cols; ?>" rows="<?php echo $rows; ?>"><?php echo wp_unslash($Html -> field_value($name)); ?></textarea><?php

            if ($error != false) {
                echo $Html -> field_error($name);
            }

            $textarea = ob_get_clean();
            return $textarea;
        }

        public function radio( $name = null, $buttons = array(), $options = array() ) {
            global $Html;
        
            $defaults = array(
                'error'     => true,
                'onclick'   => 'return;',
                'separator' => '<br/>',
                'default'   => null,
            );
            $r = wp_parse_args( $options, $defaults );
            extract( $r, EXTR_SKIP );
        
            $current = $Html->field_value( $name );
        
            ob_start();
        
            if ( ! empty( $buttons ) ) {
                foreach ( $buttons as $value => $label ) {
        
                    $is_checked = ( ( $current !== '' && $current == $value )
                                    || ( $current === '' && $default !== null && $value == $default ) );
                    ?>
                    <label>
                        <input
                            type="radio"
                            id="<?php echo $Html->field_id( $name ); ?>_<?php echo esc_attr( $value ); ?>"
                            name="<?php echo $name; ?>"
                            value="<?php echo esc_attr( $value ); ?>"
                            onclick="<?php echo $onclick; ?>"
                            <?php echo $is_checked ? 'checked="checked"' : ''; ?>
                        />
                        <?php echo esc_html__( $label, 'wp-mailinglist' ); ?>
                    </label><?php echo $separator; ?>
                    <?php
                }
            }
        
            if ( $error ) {
                echo $Html->field_error( $name );
            }
        
            return ob_get_clean();
        }

        public function checkbox($name = null, $boxes = array(), $options = array())
        {
            global $Html;

            $defaults = array('separator' => '<br/>');
            $r = wp_parse_args($options, $defaults);
            extract($r, EXTR_SKIP);

            ob_start(); ?>
            <?php $language =  $this -> language_default(); ?>

            <?php if (!empty($boxes)) : ?>
            <?php foreach ( $boxes as $value => $label ) :
				?>
				<label>
					<input type="checkbox"
						   id="<?php echo $Html->field_id( $name ); ?>check_<?php echo $value; ?>"
						   name="<?php echo $name; ?>"
						   value="<?php echo esc_attr( $value ); ?>"
						   <?php checked( in_array( $value, (array) $Html->field_value( $name ), true ) ); ?>
					/>
					<?php echo esc_html__( $label, 'wp-mailinglist' ); ?>
				</label><?php echo $separator; ?>
				<?php
			endforeach; ?>
        <?php endif; ?>

            <?php

            $checkbox = ob_get_clean();
            return $checkbox;
        }

        public function select($name = null, $selects = array(), $options = array())
        {
            global $Html;

            $defaults = array('error' => true, 'class' => "widefat", 'width' => "auto", 'onchange' => 'return;');
            $r = wp_parse_args($options, $defaults);
            extract($r, EXTR_SKIP);

            ob_start(); ?>

            <select class="<?php echo $class; ?>" style="width:<?php echo $width; ?>;" onchange="<?php echo $onchange; ?>" class="<?php echo $class; ?>" id="<?php echo $Html -> field_id($name); ?>" name="<?php echo $name; ?>">
                <option value=""><?php _e('- Select -', 'wp-mailinglist'); ?></option>
                <?php if (!empty($selects)) : ?>
                    <?php foreach ($selects as $skey => $sval) : ?>
                        <option <?php echo ($Html -> field_value($name) == $skey) ? 'selected="selected"' : ''; ?> value="<?php echo esc_attr(wp_unslash($skey)); ?>"><?php echo __($sval); ?></option>
                    <?php endforeach; ?>
                <?php endif; ?>
            </select>

            <?php

            if ($error != false) {
                echo $Html -> field_error($name);
            }

            $select = ob_get_clean();
            return $select;
        }

        public function submit($name = null, $options = array())
        {
            global $Html;

            $defaults = array('class' => "button-primary");
            $r = wp_parse_args($options, $defaults);
            extract($r, EXTR_SKIP);

            ob_start(); ?>

            <button type="submit" name="<?php echo $Html -> sanitize($name); ?>" value="1" class="<?php echo esc_attr(wp_unslash($class)); ?>">
                <?php echo esc_attr(wp_unslash(__($name))); ?>
            </button>

            <?php

            $submit = ob_get_clean();
            return $submit;
        }
    }
}

?>