
	<form action="?page=<?php echo $this -> sections -> orders; ?>&method=mass" method="post" onsubmit="if (!confirm('<?php echo esc_js(__('Are you sure you wish to execute this action?', 'wp-mailinglist')); ?>')) { return false; }" id="ordersform">
		<?php wp_nonce_field($this -> sections -> orders . '_mass'); ?>
		<div class="tablenav">
			<div class="alignleft">
				<select name="action" style="width:auto;" class="widefat">
					<option value=""><?php _e('- Bulk Actions -', 'wp-mailinglist'); ?></option>
					<option value="delete"><?php _e('Delete', 'wp-mailinglist'); ?></option>
				</select>
				<button value="1" type="submit" class="button-secondary" name="execute">
					<?php _e('Apply', 'wp-mailinglist'); ?>
				</button>
			</div>
			<?php $this -> render('pagination', array('paginate' => $paginate), true, 'admin'); ?>
		</div>
		
		<?php
		
		$orderby = (empty($_GET['orderby'])) ? 'modified' : esc_html($_GET['orderby']);
		$order = (empty($_GET['order'])) ? 'desc' : strtolower(esc_html($_GET['order']));
		$otherorder = ($order == "desc") ? 'asc' : 'desc';
		
		$colspan = 6;
		
		?>
		
		<table class="widefat">
			<thead>
				<tr>
					<td class="check-column"><input type="checkbox" name="checkboxall" value="checkboxall" id="checkboxall" /></td>
					<th class="column-id <?php echo ($orderby == "id") ? 'sorted ' . $order : 'sortable desc'; ?>">
						<a href="<?php echo $Html -> retainquery('orderby=id&order=' . (($orderby == "id") ? $otherorder : "asc")); ?>">
							<span><?php _e('ID', 'wp-mailinglist'); ?></span>
							<span class="sorting-indicator"></span>
						</a>
					</th>
					<th class="column-list_id <?php echo ($orderby == "list_id") ? 'sorted ' . $order : 'sortable desc'; ?>">
						<a href="<?php echo $Html -> retainquery('orderby=list_id&order=' . (($orderby == "list_id") ? $otherorder : "asc")); ?>">
							<span><?php _e('Mailing List', 'wp-mailinglist'); ?></span>
							<span class="sorting-indicator"></span>
						</a>
					</th>
					<?php if (empty($hide_subscriber)) : ?>
						<th class="column-subscriber_id <?php echo ($orderby == "subscriber_id") ? 'sorted ' . $order : 'sortable desc'; ?>">
							<a href="<?php echo $Html -> retainquery('orderby=subscriber_id&order=' . (($orderby == "subscriber_id") ? $otherorder : "asc")); ?>">
								<span><?php _e('Subscriber', 'wp-mailinglist'); ?></span>
								<span class="sorting-indicator"></span>
							</a>
						</th>
						<?php $colspan++; ?>
					<?php endif; ?>
					<th class="column-amount <?php echo ($orderby == "amount") ? 'sorted ' . $order : 'sortable desc'; ?>">
						<a href="<?php echo $Html -> retainquery('orderby=amount&order=' . (($orderby == "amount") ? $otherorder : "asc")); ?>">
							<span><?php _e('Amount', 'wp-mailinglist'); ?></span>
							<span class="sorting-indicator"></span>
						</a>
					</th>
					<th class="column-pmethod <?php echo ($orderby == "pmethod") ? 'sorted ' . $order : 'sortable desc'; ?>">
						<a href="<?php echo $Html -> retainquery('orderby=pmethod&order=' . (($orderby == "pmethod") ? $otherorder : "asc")); ?>">
							<span><?php _e('Payment Method', 'wp-mailinglist'); ?></span>
							<span class="sorting-indicator"></span>
						</a>
					</th>
					<th class="column-created <?php echo ($orderby == "created") ? 'sorted ' . $order : 'sortable desc'; ?>">
						<a href="<?php echo $Html -> retainquery('orderby=created&order=' . (($orderby == "created") ? $otherorder : "asc")); ?>">
							<span><?php _e('Date', 'wp-mailinglist'); ?></span>
							<span class="sorting-indicator"></span>
						</a>
					</th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<td class="check-column"><input type="checkbox" name="checkboxall" value="checkboxall" id="checkboxall" /></td>
					<th class="column-id <?php echo ($orderby == "id") ? 'sorted ' . $order : 'sortable desc'; ?>">
						<a href="<?php echo $Html -> retainquery('orderby=id&order=' . (($orderby == "id") ? $otherorder : "asc")); ?>">
							<span><?php _e('ID', 'wp-mailinglist'); ?></span>
							<span class="sorting-indicator"></span>
						</a>
					</th>
					<th class="column-list_id <?php echo ($orderby == "list_id") ? 'sorted ' . $order : 'sortable desc'; ?>">
						<a href="<?php echo $Html -> retainquery('orderby=list_id&order=' . (($orderby == "list_id") ? $otherorder : "asc")); ?>">
							<span><?php _e('Mailing List', 'wp-mailinglist'); ?></span>
							<span class="sorting-indicator"></span>
						</a>
					</th>
					<?php if (empty($hide_subscriber)) : ?>
						<th class="column-subscriber_id <?php echo ($orderby == "subscriber_id") ? 'sorted ' . $order : 'sortable desc'; ?>">
							<a href="<?php echo $Html -> retainquery('orderby=subscriber_id&order=' . (($orderby == "subscriber_id") ? $otherorder : "asc")); ?>">
								<span><?php _e('Subscriber', 'wp-mailinglist'); ?></span>
								<span class="sorting-indicator"></span>
							</a>
						</th>
					<?php endif; ?>
					<th class="column-amount <?php echo ($orderby == "amount") ? 'sorted ' . $order : 'sortable desc'; ?>">
						<a href="<?php echo $Html -> retainquery('orderby=amount&order=' . (($orderby == "amount") ? $otherorder : "asc")); ?>">
							<span><?php _e('Amount', 'wp-mailinglist'); ?></span>
							<span class="sorting-indicator"></span>
						</a>
					</th>
					<th class="column-pmethod <?php echo ($orderby == "pmethod") ? 'sorted ' . $order : 'sortable desc'; ?>">
						<a href="<?php echo $Html -> retainquery('orderby=pmethod&order=' . (($orderby == "pmethod") ? $otherorder : "asc")); ?>">
							<span><?php _e('Payment Method', 'wp-mailinglist'); ?></span>
							<span class="sorting-indicator"></span>
						</a>
					</th>
					<th class="column-created <?php echo ($orderby == "created") ? 'sorted ' . $order : 'sortable desc'; ?>">
						<a href="<?php echo $Html -> retainquery('orderby=created&order=' . (($orderby == "created") ? $otherorder : "asc")); ?>">
							<span><?php _e('Date', 'wp-mailinglist'); ?></span>
							<span class="sorting-indicator"></span>
						</a>
					</th>
				</tr>
			</tfoot>
			<tbody>
				<?php if (empty($orders)) : ?>
					<tr class="no-items">
						<td class="colspanchange" colspan="<?php echo esc_html($colspan); ?>"><?php _e('No orders were found', 'wp-mailinglist'); ?></td>
					</tr>
				<?php else : ?>
					<?php $class = ''; ?>
					<?php foreach ($orders as $order) : ?>
						<?php $subscriber = $Subscriber -> get($order -> subscriber_id, false); ?>
						<?php $mailinglist = $Mailinglist -> get($order -> list_id, false); ?>
						<tr id="orderrow<?php echo $order -> id; ?>" class="<?php echo $class = (empty($class)) ? 'alternate' : ''; ?>">
							<th class="check-column"><input type="checkbox" name="orderslist[]" value="<?php echo $order -> id; ?>" id="checklist<?php echo $order -> id; ?>" /></th>
							<td><a href="<?php echo admin_url('admin.php?page=' . $this -> sections -> orders . '&method=view&id=' . $order -> id); ?>"><?php echo $order -> id; ?></a></td>
							<td>
								<strong><a class="row-title" href="?page=<?php echo $this -> sections -> lists; ?>&amp;method=view&amp;id=<?php echo $mailinglist -> id; ?>" title="<?php _e('View the details of this mailinglist', 'wp-mailinglist'); ?>"><?php echo __($mailinglist -> title); ?></a></strong>
								<div class="row-actions">
									<span class="edit"><?php echo $Html -> link(__('Edit', 'wp-mailinglist'), '?page=' . $this -> sections -> orders . '&amp;method=save&amp;id=' . $order -> id); ?> |</span>
									<span class="delete"><?php echo ( $Html -> link(__('Delete', 'wp-mailinglist'), wp_nonce_url('?page=' . $this -> sections -> orders . '&amp;method=delete&amp;id=' . $order -> id,   $this -> sections -> orders . '_delete'), array('class' => "submitdelete", 'onclick' => "if (!confirm('" . __('Are you sure you want to delete this order? Linked subscription will be removed as well.', 'wp-mailinglist') . "')) { return false; }"))); ?> |</span>
									<span class="view"><?php echo $Html -> link(__('View Order', 'wp-mailinglist'), '?page=' . $this -> sections -> orders . '&amp;method=view&amp;id=' . $order -> id); ?></span>
								</div>
							</td>
							<?php if (empty($hide_subscriber)) : ?>
								<td><a href="?page=<?php echo $this -> sections -> subscribers; ?>&amp;method=view&amp;id=<?php echo $subscriber -> id; ?>" title="<?php _e('View the details of this subscriber', 'wp-mailinglist'); ?>"><?php echo $subscriber -> email; ?></a></td>
							<?php endif; ?>
							<td><label for="checklist<?php echo $order -> id; ?>"><strong><?php echo $Html -> currency(); ?><?php echo number_format($order -> amount, 2, '.', ''); ?></strong></label></td>
							<td><label for="checklist<?php echo $order -> id; ?>"><?php echo (!empty($order -> pmethod) && $order -> pmethod == "2co") ? '2CheckOut' : 'PayPal'; ?></label></td>
							<td><label for="checklist<?php echo $order -> id; ?>"><abbr title="<?php echo $order -> modified; ?>"><?php echo $Html -> gen_date(false, strtotime($order -> modified)); ?></abbr></label></td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>
			</tbody>
		</table>
		<div class="tablenav">
			<div class="alignleft">
				<?php if (empty($_GET['showall'])) : ?>
					<select class="widefat" style="width:auto;" name="perpage" onchange="change_perpage(this.value);">
						<option value=""><?php _e('- Per Page -', 'wp-mailinglist'); ?></option>
						<?php $s = 5; ?>
						<?php while ($s <= 200) : ?>
							<option <?php echo (isset($_COOKIE[$this -> pre . 'ordersperpage']) && $_COOKIE[$this -> pre . 'ordersperpage'] == $s) ? 'selected="selected"' : ''; ?> value="<?php echo esc_html($s); ?>"><?php echo esc_html($s); ?> <?php _e('orders', 'wp-mailinglist'); ?></option>
							<?php $s += 5; ?>
						<?php endwhile; ?>
						<?php if (isset($_COOKIE[$this -> pre . 'ordersperpage'])) : ?>
							<option selected="selected" value="<?php echo $_COOKIE[$this -> pre . 'ordersperpage']; ?>"><?php echo $_COOKIE[$this -> pre . 'ordersperpage']; ?></option>
						<?php endif; ?>
					</select>
				<?php endif; ?>
			</div>
			<?php $this -> render('pagination', array('paginate' => $paginate), true, 'admin'); ?>
		</div>	
		
		<script type="text/javascript">
		function change_perpage(perpage) {
			if (perpage != "") {
				document.cookie = "<?php echo $this -> pre; ?>ordersperpage=" + perpage + "; expires=<?php echo $Html -> gen_date($this -> get_option('cookieformat'), strtotime("+30 days")); ?> UTC; path=/";
				window.location = "<?php echo preg_replace("/\&?" . $this -> pre . "page\=(.*)?/si", "", $_SERVER['REQUEST_URI']); ?>";
			}
		}
		
		function change_sorting(field, dir) {
			document.cookie = "<?php echo $this -> pre; ?>orderssorting=" + field + "; expires=<?php echo $Html -> gen_date($this -> get_option('cookieformat'), strtotime("+30 days")); ?> UTC; path=/";
			document.cookie = "<?php echo $this -> pre; ?>orders" + field + "dir=" + dir + "; expires=<?php echo $Html -> gen_date($this -> get_option('cookieformat'), strtotime("+30 days")); ?> UTC; path=/";
			window.location = "<?php echo preg_replace("/\&?" . $this -> pre . "page\=(.*)?/si", "", $_SERVER['REQUEST_URI']); ?>";
		}
		</script>
	</form>